<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform version="1.0" id="msi setup build overview" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- first version by Gunnar Holtz; extended by Philip Erdoes -->
<!-- Voraussetzungen: Mindestens IE 5 plus MSXML3. IE 6 ist empfohlen.-->
<!-- Achtung: In XSL sollte man Umlaute vermeiden (hoechstens Kommentare), zur Sicherheit knnte man obiges 'encoding' auf 'UTF-8' setzen -->

<!-- Einrueckung von HTML unabhaengig von XSL/XML, deswegen quasi zwei Einrueckungsebenen; mit dem 'indent' Befehl sollte die HTML Einrueckung eigentlich auch uebergeben werden, geht bei IE nicht immer-->
<xsl:output indent="yes"  method="xml"/>

<xsl:variable name="featureSet" select="descendant::Feature" />      
<xsl:variable name="visibleSet" select="$featureSet[@Visible='YES'] | $featureSet[@Visible='Yes'] | $featureSet[@Visible='yes']" />
<xsl:variable name="compSet" select="descendant::Component" />
<xsl:variable name="fileSet" select="descendant::File" />

<xsl:template match="/">

<HTML>
  <head>
    <!-- PE Cascading Style Sheets funktionieren bei Aufruf aus einer .htm Datei nicht im <head> -->
  </head>
  
  <BODY>
    <xsl:text disable-output-escaping="yes">
    <!-- CSS Krempel fr Formatierung (in Kommentaren traditionell wg. lteren Browsern) -->
    <![CDATA[
      <style type="text/css">
        <!--
          h2 { color:red; }
          h3 { margin-bottom:5px; }
          th { font-style:italic }
        -->
      </style>
    ]]>
    </xsl:text>

    <xsl:apply-templates select="//Product" />
  </BODY>    
</HTML>
</xsl:template>


<xsl:template name="ProcessFeatures">

    <h3><a name="__Features__">Visible Features:</a></h3> 
    <a href="#__TOC__">TOC</a>
    
    <TABLE cellSpacing="0" cellPadding="0" width="100%" border="1">
        <TR>
          <TD>No.</TD><TD>Name</TD><TD>Visible</TD><TD>Destination</TD>
        </TR>
        <xsl:for-each select="$visibleSet">
        <TR>
          <TD><xsl:value-of select="position()" /></TD>
          <TD><xsl:value-of select="@Name" /></TD>
          <TD><xsl:value-of select="@Visible" /></TD>
          <TD><xsl:value-of select="@Destination" /></TD>
        </TR>
        </xsl:for-each>
    </TABLE>
    <br/>
</xsl:template>



<xsl:template match="//Product">

    <h2>Overview after a MSI setup build</h2>
    <h3 align="right"><i>(last change PE 23.8.2003)</i></h3>
          
    <!-- TOC -->
    <h3><a name="__TOC__"> Table of Contents (TOC)</a></h3>
     <b>     
      <a href="#__Features__">Features</a>
      <xsl:text> | </xsl:text>
      <a href="#__Files__">Files</a>
      <xsl:text> | </xsl:text>
      <!--a href="#__source_path__">Source paths</a-->
      <!--xsl:text> | </xsl:text-->
      <a href="#__statistics_for_correctness__">Statistics for correctness</a>
      <hr/>
     </b>
    
    
    <p>
    <h3>Statistics:</h3>
      No. of top-level features:  <xsl:value-of select="count($featureSet)-count(child::Feature)" /> <br/>
      No. of user-visible features:  <xsl:value-of select="count($visibleSet)" /> <br/>
      No. of features: <xsl:value-of select="count($featureSet)" /> <br/>
      No. of components: <xsl:value-of select="count($compSet)" /> <br/>
      No. of files: <xsl:value-of select="count($fileSet)" /> <br/>
    </p>
    
    <TABLE cellSpacing="0" cellPadding="0" width="45%" border="0" style="table-layout:fixed">
      <TR> <TH width="10%"></TH> <TH width="5%"></TH> <TH width="10%"></TH> <TH width="10%"></TH> </TR>
      <TR>
        <TD>Comp. with 0 files:    </TD><TD> <xsl:value-of select="count($compSet[count(child::File) = 0])" /> </TD>
        <TD>Comp. with 1 file:     </TD><TD> <xsl:value-of select="count($compSet[count(child::File) = 1])" /> </TD>
      </TR> <TR>
        <TD>Comp. with 2 files:    </TD><TD> <xsl:value-of select="count($compSet[count(child::File) = 2])" /> </TD>
        <TD>Comp. with >=3 files:  </TD><TD> <xsl:value-of select="count($compSet[count(child::File) >= 3])" /> </TD>
      </TR>
    </TABLE>

		<hr/>
    <xsl:call-template name="ProcessFeatures" />
		<br/>

    <h3><a name="__Files__"> Files sorted by source path of build: </a></h3>
    <a href="#__TOC__">TOC</a>
    <font face="Arial Narrow">
      <TABLE height="100%" cellSpacing="0" cellPadding="0" width="100%" border="1">
      <!--TABLE height="100%" cellSpacing="0" cellPadding="0" width="100%" border="1" style="table-layout:fixed"-->
          <TR>
            <TH>No.</TH><TH>Name</TH><TH>Version</TH><TH>Date</TH><TH>Size</TH>
            <!--TD width="3%">No.</TD><TD width="74%">Name</TD><TD  width="10%">Version</TD><TD width="8%">Date</TD><TD  width="5%">Size</TD-->
          </TR>
          <xsl:for-each select="$fileSet">
            <xsl:sort select="@Name" />
          <TR>
            <TD><xsl:value-of select="position()" /></TD>
            <TD><xsl:value-of select="@Name" /></TD>
            <TD><xsl:value-of select="@Version" /></TD>
            <TD><xsl:value-of select="@Date" /></TD>
            <TD align="right"><xsl:value-of select="@Size" /></TD>
          </TR>
          </xsl:for-each>
      </TABLE>
    </font>
    <br/>

    <h3><a name="__statistics_for_correctness__"> Statistics for correctness of XML file:</a></h3>
    <a href="#__TOC__">TOC</a>
    <TABLE cellSpacing="0" cellPadding="0" width="80%" border="0">
      <TR>
        <TD width="30%"></TD> <TD width="8%"></TD> <TD width="38%"></TD> <TD width="4%"></TD>
      </TR>
      <TR>
        <TD>Files, that do not belong to a comp.  (=error): </TD><TD> <xsl:value-of select="count($fileSet)-count($featureSet/Component/File)" /> </TD>
        <TD>Comp. with 0 files and 0 shortcuts, e.g. 'Environment var.': </TD><TD>  <xsl:value-of select="count(descendant::Component[count(child::File)+count(child::Shortcut) = 0])" /> </TD>
      </TR>
      <TR>
        <TD>Comp., that do not belong to a feature (=error): </TD><TD> <xsl:value-of select="count($compSet)-count($featureSet/Component)" /> </TD>
        <TD>Features, that do not belong to a product (=error): </TD><TD> <xsl:value-of select="count(../descendant::Feature)-count(../Product//Feature)" /> </TD>
      </TR>
      <TR>
        <TD>No. of products in file (normal is 1): </TD><TD> <xsl:value-of select="count(../descendant::Product)" /> </TD>
      </TR>
    </TABLE>
    <hr/> <br/>
    <a href="#top">To the top</a><br/>


</xsl:template>


</xsl:transform>
